/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import Entity.PlayerSave;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class HighScoresState
extends GameState {
    private Font font;
    private Font fontBig;
    private MenuOption mo;
    private Mouse mouse;

    public HighScoresState(GameStateManager gsm) {
        this.gsm = gsm;
        PlayerSave.getHighScores();
        this.font = new Font("Arial", 0, 22);
        this.fontBig = new Font("Arial", 0, 28);
        this.mo = new MenuOption("Back", this.font, 400, 350);
        this.mouse = new Mouse();
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.setFont(this.fontBig);
        g.setColor(Color.white);
        this.gsm.drawCenteredString("--> High Scores - " + PlayerSave.difficultyString + " <--", 800, 80, g);
        PlayerSave.drawHighScore(g, this.font);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("Back", 800, 700, g);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK) && this.mo.getChoice() == 0) {
                this.gsm.setState(0);
            }
        } else if (Keys.isKeyPressed(Keys.ENTER)) {
            this.gsm.setState(0);
        }
    }
}

